--- @param x number
--- @param y number
--- @return int2
function int2(x, y)
	local c = New("int2")
	c.x = x
	c.y = y
	return c
end

--- @param x number
--- @param y number
--- @param z number
--- @return Vector3
function Vector3(x, y, z)
	local c = New("Vector3")
	c.x = x
	c.y = y
	c.z = z
	return c
end

--- @type fun(r?: number, g?: number, b?: number, a?: number): Color
function Color(r, g, b, a)
	local c = New("Color")
	c.r = r / 255.0
	c.g = g / 255.0
	c.b = b / 255.0
	c.a = (a or 255.0) / 255.0
	return c
end

---@param fileName string
---@return CAssetModel
function NewCAssetModel(fileName)
	local asset = New("CAssetModel")
	asset.fileName = fileName
	return asset
end

---@param ... string
---@return CAssetModelsContainers
function NewCAssetModelsContainers(folder, ...)
	local asset = New("CAssetModelsContainers")
	local models = {}
	local args = { ... }
	for _, fileName in ipairs(args) do
		table.insert(models, NewCAssetModel(folder .. fileName))
	end
	asset.models = CreateLuaEntityList("CAssetModel", models)
	return asset
end

---@param folder string
---@param ... string
---@return CAssetModels
function NewCAssetModels(folder, ...)
	local asset = New("CAssetModels")
	local models = {}
	local args = { ... }
	for _, fileName in ipairs(args) do
		table.insert(models, NewCAssetModel(folder .. fileName))
	end
	asset.models = CreateLuaEntityList("CAssetModel", models)
	return asset
end

---@param folder string
---@param ... string|number
---@return CAssetModels
function NewCAssetModelsProbas(folder, ...)
	local args = { ... }
	local asset = New("CAssetModels")
	local models = {}
	local probas = {}
	for i = 1, #args, 2 do
		table.insert(models, NewCAssetModel(folder .. args[i]))
		table.insert(probas, args[i + 1])
	end
	asset.models = CreateLuaEntityList("CAssetModel", models)
	asset.probas = probas
	return asset
end

---@param fileName string
---@return CAssetMaterial
function NewCAssetMaterial(fileName)
	local asset = New("CAssetMaterial")
	asset.fileName = fileName
	return asset
end

-- When placed on the hexagon, angle is first computed, this position is set relative to the new direction
---@param nbMax number
---@param angle number
---@param pos Vector3
---@return CStackInfos
function NewStack(nbMax, angle, pos)
	local stock = New("CStackInfos")
	stock.nbMax = nbMax
	stock.angle = angle or 0
	if pos ~= nil then
		stock.pos = pos
	end
	return stock;
end

--- @param bitNb number
--- @param valueMax number
--- @return CItemData
function NewData(bitNb, valueMax)
	local data = New("CItemData")
	data.bitNb = bitNb
	data.valueMax = valueMax
	return data;
end

---@param fileName string
---@param spriteName string
---@return CAssetSprite
function NewCAssetSprite(fileName, spriteName)
	local asset = New("CAssetSprite")
	asset.fileName = fileName
	asset.spriteName = spriteName
	return asset
end

---@param showInItemBar? boolean
---@return CItemUIGroup
function NewCItemUIGroup(showInItemBar)
	local obj = New("CItemUIGroup")
	obj.icon = nil
	obj.showInItemBar = showInItemBar or false
	return obj
end

-- Concatened list of inputs [item, number], then a separator string, then list of ouputs [item, number]
---@param levelNumber number
---@return CLevel
function NewLevel(levelNumber)
	local data = New("CLevel")
	data.levelNumber = levelNumber
	return data;
end

---@param fileName string
---@return CAssetTexture2D
function NewCAssetTexture2D(fileName)
	local asset = New("CAssetTexture2D")
	asset.fileName = fileName
	return asset
end

function NewCursor(x, y, ...)
	local obj = New("CCursor")
	obj.textures2D = { ... }
	obj.hotspot = int2(x, y)
	return obj;
end

---@param fileName string
---@return CAssetMusic
function NewCAssetMusic(fileName)
	local asset = New("CAssetMusic")
	asset.fileName = fileName
	return asset;
end

-- Concatened list of inputs { item1, number1, item2, number2 }, then list of ouputs { item1, number1, item2, number2 }
---@param inputs (CItem|number)[]
---@param outputs (CItem|number)[]
---@param duration? number
---@return CRecipe
function NewRecipe(inputs, outputs, duration)
	local data = New("CRecipe")
	data.duration = duration or -1
	data.Create(inputs, outputs)
	return data;
end

-- Concatened list of inputs { item1, number1, item2, number2 }, then list of ouputs { item1, number1, item2, number2 }
---@param cityPop number
---@param inputs (CItem|number)[]
---@param outputs (CItem|number)[]
---@return CRecipe
function NewRecipeCity(cityPop, inputs, outputs)
	local data = New("CRecipe")
	data.cityPop = cityPop or -1
	data.duration = -1
	data.Create(inputs, outputs)
	return data;
end

---@param fileName string
---@return CAssetAudio
function NewCAssetAudio(fileName)
	local asset = New("CAssetAudio")
	asset.fileName = fileName
	return asset
end

--- Concatened list of inputs {item1, number1, item2, number2}, then list of ouputs {item1, number1, item2, number2}
---@param volume number
---@param ... string
---@return CAssetSound
function NewCAssetSound(volume, ...)
	local asset = New("CAssetSound")
	asset.volume = volume
	local clips = {}
	local args = { ... }
	for _, fileName in ipairs(args) do
		table.insert(clips, NewCAssetAudio(fileName))
	end
	asset.clips = CreateLuaEntityList("CAssetAudio", clips)
	return asset;
end

--- Concatened list of inputs {item1, number1, item2, number2}, then list of ouputs {item1, number1, item2, number2}
---@param volume number
---@param filename string
---@return CAssetSoundLooped
function NewCAssetSoundLooped(volume, filename)
	local data = New("CAssetSoundLooped")
	data.volume = volume
	data.fileName = filename
	return data;
end

-- Function to generate depot ranges higher than 3
-- ---@param range number
-- function GenerateNeisRef(range)
-- 	local odds = {}
-- 	local evens = {}
-- 	for i = 0, range do
-- 		odds[i] = { int2(0, 0) }
-- 		evens[i] = { int2(0, 0) }
-- 		for r = 1, range do
-- 			for y = -r, r do
-- 				local x_right_odd = r - math.floor(math.abs(y) / 2)
-- 				local x_left_odd = -r + math.floor((math.abs(y) + 1) / 2)
-- 				local x_right_even = r - math.floor((math.abs(y) + 1) / 2)
-- 				local x_left_even = -r + math.floor(math.abs(y) / 2)
-- 				table.insert(odds[i], int2(x_right_odd, y))
-- 				table.insert(odds[i], int2(x_left_odd, y))
-- 				table.insert(evens[i], int2(x_right_even, y))
-- 				table.insert(evens[i], int2(x_left_even, y))
-- 			end
-- 			for x = 1, r - 1 do
-- 				local x_odd = r - x - math.floor(math.abs(r) / 2)
-- 				local x_even = r - x - math.floor((math.abs(r) + 1) / 2)
-- 				table.insert(odds[i], int2(x_odd, r));
-- 				table.insert(odds[i], int2(x_odd, -r));
-- 				table.insert(evens[i], int2(x_even, r));
-- 				table.insert(evens[i], int2(x_even, -r));
-- 			end
-- 		end
-- 	end
-- 	GDrones.neisRef_Odd = odds
-- 	GDrones.neisRef_Even = evens
-- end

-- GenerateNeisRef(3)
